// --------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
// --------------------------------------------------------------------
// Copyright (c) 2005 by Lattice Semiconductor Corporation
// --------------------------------------------------------------------
//
//
//                     Lattice Semiconductor Corporation
//                     5555 NE Moore Court
//                     Hillsboro, OR 97214
//                     U.S.A.
//
//                     TEL: 1-800-Lattice  (USA and Canada)
//                          1-408-826-6000 (other locations)
//
//                     web: http://www.latticesemi.com/
//                     email: techsupport@latticesemi.com
//
// --------------------------------------------------------------------
//
// Simulation Library File for EC/XP
//
// $Header: /home/dmsys/pvcs/RCSMigTest/rcs/verilog/pkg/versclibs/data/orca5mg/RCS/SP8KA.v,v 1.7 2005/05/19 20:09:00 pradeep Exp $ 
//
`timescale 1ns / 1ps
module SP8KA (CE,CLK,WE,CS0,CS1,CS2,RST,
              DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,
              DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,
              AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,AD12,
              DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,
              DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17);


   parameter  DATA_WIDTH = 18;
   parameter  REGMODE = "NOREG";
   parameter  RESETMODE = "SYNC";
   parameter  CSDECODE = "000";
   parameter  WRITEMODE = "NORMAL";
   parameter  ARRAY_SIZE = 9216;
   parameter  GSR = "DISABLED";

parameter INITVAL_00 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_01 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_02 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_03 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_04 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_05 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_06 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_07 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_08 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_09 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_0A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_0B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_0C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_0D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_0E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_0F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_10 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_11 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_12 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_13 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_14 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_15 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_16 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_17 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_18 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_19 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
parameter INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;

input    DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8,
         DI9, DI10, DI11, DI12, DI13, DI14, DI15, DI16, DI17,
         AD0, AD1, AD2, AD3, AD4, AD5, AD6, AD7, AD8,
         AD9,  AD10,  AD11, AD12, 
         CE, CLK, WE, CS0, CS1, CS2, RST;

output   DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8,
         DO9, DO10, DO11, DO12, DO13, DO14, DO15, DO16, DO17;
reg lo, hi;

initial
begin
   lo = 1'b0;
   hi = 1'b1;
end

DP8KA EBR_INST (.DIA0(DI0), .DIA1(DI1), .DIA2(DI2), .DIA3(DI3), .DIA4(DI4),
       .DIA5(DI5), .DIA6(DI6), .DIA7(DI7), .DIA8(DI8), .DIA9(DI9), .DIA10(DI10), 
       .DIA11(DI11), .DIA12(DI12), .DIA13(DI13), .DIA14(DI14), .DIA15(DI15),
       .DIA16(DI16), .DIA17(DI17), .DIB0(lo), .DIB1(lo), .DIB2(lo), .DIB3(lo),
       .DIB4(lo), .DIB5(lo), .DIB6(lo), .DIB7(lo), .DIB8(lo), .DIB9(lo),
       .DIB10(lo), .DIB11(lo), .DIB12(lo), .DIB13(lo), .DIB14(lo), .DIB15(lo),
       .DIB16(lo), .DIB17(lo), .CEA(CE), .CLKA(CLK), .WEA(WE), .CSA0(CS0), .CSA1(CS1),
       .CSA2(CS2), .RSTA(RST), .ADA0(AD0), .ADA1(AD1), .ADA2(AD2), .ADA3(AD3), .ADA4(AD4),
       .ADA5(AD5), .ADA6(AD6), .ADA7(AD7), .ADA8(AD8), .ADA9(AD9), .ADA10(AD10),
       .ADA11(AD11), .ADA12(AD12), .CEB(lo), .CLKB(lo), .WEB(lo),
       .CSB0(lo), .CSB1(lo), .CSB2(lo), .RSTB(hi), .ADB0(lo), .ADB1(lo), .ADB2(lo),
       .ADB3(lo), .ADB4(lo), .ADB5(lo), .ADB6(lo), .ADB7(lo), .ADB8(lo),
       .ADB9(lo), .ADB10(lo), .ADB11(lo), .ADB12(lo), 
       .DOA0(DO0), .DOA1(DO1), .DOA2(DO2), .DOA3(DO3), .DOA4(DO4), .DOA5(DO5), .DOA6(DO6), 
       .DOA7(DO7), .DOA8(DO8), .DOA9(DO9), .DOA10(DO10), .DOA11(DO11), .DOA12(DO12),
       .DOA13(DO13), .DOA14(DO14), .DOA15(DO15), .DOA16(DO16), .DOA17(DO17), .DOB0(),
       .DOB1(), .DOB2(), .DOB3(), .DOB4(), .DOB5(), .DOB6(),
       .DOB7(), .DOB8(), .DOB9(), .DOB10(), .DOB11(), .DOB12(), 
       .DOB13(), .DOB14(), .DOB15(), .DOB16(), .DOB17());

defparam EBR_INST.DATA_WIDTH_A = DATA_WIDTH;
defparam EBR_INST.DATA_WIDTH_B = DATA_WIDTH;
defparam EBR_INST.REGMODE_A = REGMODE;
defparam EBR_INST.REGMODE_B = REGMODE;
defparam EBR_INST.RESETMODE = RESETMODE;
defparam EBR_INST.CSDECODE_A = CSDECODE;
defparam EBR_INST.CSDECODE_B = CSDECODE;
defparam EBR_INST.WRITEMODE_A = WRITEMODE;
defparam EBR_INST.WRITEMODE_B = WRITEMODE;
defparam EBR_INST.GSR = GSR;
defparam EBR_INST.INITVAL_00 = INITVAL_00;
defparam EBR_INST.INITVAL_01 = INITVAL_01;
defparam EBR_INST.INITVAL_02 = INITVAL_02;
defparam EBR_INST.INITVAL_03 = INITVAL_03;
defparam EBR_INST.INITVAL_04 = INITVAL_04;
defparam EBR_INST.INITVAL_05 = INITVAL_05;
defparam EBR_INST.INITVAL_06 = INITVAL_06;
defparam EBR_INST.INITVAL_07 = INITVAL_07;
defparam EBR_INST.INITVAL_08 = INITVAL_08;
defparam EBR_INST.INITVAL_09 = INITVAL_09;
defparam EBR_INST.INITVAL_0A = INITVAL_0A;
defparam EBR_INST.INITVAL_0B = INITVAL_0B;
defparam EBR_INST.INITVAL_0C = INITVAL_0C;
defparam EBR_INST.INITVAL_0D = INITVAL_0D;
defparam EBR_INST.INITVAL_0E = INITVAL_0E;
defparam EBR_INST.INITVAL_0F = INITVAL_0F;
defparam EBR_INST.INITVAL_10 = INITVAL_10;
defparam EBR_INST.INITVAL_11 = INITVAL_11;
defparam EBR_INST.INITVAL_12 = INITVAL_12;
defparam EBR_INST.INITVAL_13 = INITVAL_13;
defparam EBR_INST.INITVAL_14 = INITVAL_14;
defparam EBR_INST.INITVAL_15 = INITVAL_15;
defparam EBR_INST.INITVAL_16 = INITVAL_16;
defparam EBR_INST.INITVAL_17 = INITVAL_17;
defparam EBR_INST.INITVAL_18 = INITVAL_18;
defparam EBR_INST.INITVAL_19 = INITVAL_19;
defparam EBR_INST.INITVAL_1A = INITVAL_1A;
defparam EBR_INST.INITVAL_1B = INITVAL_1B;
defparam EBR_INST.INITVAL_1C = INITVAL_1C;
defparam EBR_INST.INITVAL_1D = INITVAL_1D;
defparam EBR_INST.INITVAL_1E = INITVAL_1E;
defparam EBR_INST.INITVAL_1F = INITVAL_1F;

endmodule
